#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: UrlTest.py 10943 2018-03-27 09:37:58Z Kevin $
#
# Copyright (c) 2009 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $ (last)
# $Date: 2018-03-27 18:37:58 +0900 (週二, 27 三月 2018) $
# $Revision: 10943 $

from Iuppiter import test as TestUtil
import unittest

from Iuppiter.extension.templatetags.Url import flatHttpQueryString

TestUtil.chdirToRootDir()

class UrlTest(unittest.TestCase):
    """
    Test case for Url.
    """

    def setUp(self):
        pass;

    def testFlatHttpQueryString(self):
        testUrl = u'/test/?ajax&a=1&b=2'
        result = flatHttpQueryString('/test/?ajax', {'a': 1, 'b': 2})

        self.assertEqual(testUrl, result)

        testUrl = u'/test/?a=1&b=2'
        result = flatHttpQueryString('/test/', {'a': 1, 'b': 2})

        testUrl = u'/test/'
        result = flatHttpQueryString('/test/', {})

        self.assertEqual(testUrl, result)

if __name__ == '__main__':
    unittest.main()
