#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11267 2018-11-23 08:23:13Z Kevin $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Kevin $ (last)
# $Date: 2018-11-23 17:23:13 +0900 (週五, 23 十一月 2018) $
# $Revision: 11267 $
"""
Models for test purpose.
"""

from django.db import models

from Iuppiter.Model import BaseModelMixin

class TestModel(models.Model, BaseModelMixin):

    class Meta:
        ordering = ['name', 'lastUpdate']
        verbose_name = 'Test model'

    name = models.CharField('name', max_length=32)

    desc = models.TextField('desc', max_length=99, null=True, blank=True)

    link = models.URLField('link')

    previousUpdate = models.DateTimeField('previousUpdate', null=True)

    lastUpdate = models.DateTimeField('lastUpdate', null=True)

    statusCode = models.IntegerField('statusCode', null=True)

    def __str__(self):
        return '%s ' % (self.name)

class TestModel2(models.Model, BaseModelMixin):
    class Meta:
        verbose_name = 'Test model => 2'

class TestModel3(TestModel2, BaseModelMixin):
    class Meta:
        verbose_name = 'Test model => 3'     

import django

if django.__version__ == '1.8':
    from Iuppiter.Model import PreciseDateTimeField

    class TestPreciseDateTimeField(models.Model):
        """
        Model for testing PreciseDateTimeField.
        """

        ## Precise date time.
        time = PreciseDateTimeField()

        ## Precise date time for testing auto_now.
        updateTime = PreciseDateTimeField(auto_now=True, null=True)
