#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11630 2019-06-11 17:59:36Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-06-12 02:59:36 +0900 (週三, 12 六月 2019) $
# $Revision: 11630 $

import json

from django.views.generic import View
from django.views.decorators.csrf import csrf_exempt
from django.utils.decorators import method_decorator

from Zephyrus.facebook import settings as FBSettings
from Zephyrus.facebook import getCommentURL, getAPIData
from Zephyrus.facebook.models import APIData
from Zephyrus.comment.models import Comment

class FacebookWebHookView(View):
    def get(self, request, *args, **kwargs):
        verify = request.GET.get('hub.verify_token')
        if verify == FBSettings.ZEPHYRUS_FACEBOOK_WEBHOOK_VERIFY_TOKEN:
            return HttpResponse(request.GET.get('hub.challenge'))
        else:
            return HttpResponse('Error, invalid token')
        
    @method_decorator(csrf_exempt)
    def dispatch(self, request, *args, **kwargs):
        return super(
            FacebookWebHookView, self).dispatch(request, *args, **kwargs)

    def post(self, request, *args, **kwargs):
        msg = request.body.decode('utf-8')
        
        data = json.loads(msg)

        entry = data.get("entry")
        if entry:
            for e in entry:
                changes = e.get("changes")
                if changes:
                    for c in changes:
                        field = c.get("field")
                        message = c.get("value", {}).get("message")
                        mid = c.get("value", {}).get("id")
                        name = c.get("value", {}).get("from", {}).get("name")

                        if field == "plugin_comment":
                            url = getCommentURL(mid)
                            commentCount = getAPIData(url, "comment_count")
                           

                            # save API data
                            obj, created = APIData.objects.get_or_create(
                                url=url,
                            )
                            obj.commentCount = commentCount
                            
                            obj.save()

                            # save facebook comment
                            comment = Comment.objects.create(
                                url=url,
                                message=message,
                                facebook=True,
                                facebookMsgId=str(mid),
                                facebookUser=name,
                            )
                            
        return HttpResponse('Success')