#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: LandingSocial.py 11861 2020-01-14 12:00:19Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-01-14 21:00:19 +0900 (週二, 14 一月 2020) $
# $Revision: 11861 $

from django import template
from django.utils.safestring import mark_safe
from djangocms_forms.utils import int_to_hashid

from Iuppiter.DjangoUtil import DJANGO_VERSION

if DJANGO_VERSION <= 20000: # 2.0.0:
    from django.core.urlresolvers import reverse
else:
    from django.urls import reverse

register = template.Library()

@register.simple_tag
def LandingSocial(request, method, redirectTo=None, form=None):
    social = reverse('social:begin', args=[method])
    fromUrl = request.path 
    next = "?next=%s?fromUrl=%s" % (reverse('landing_social'), fromUrl)
    if redirectTo:
        next += ("%26redirectTo=" + redirectTo)
    url = social + next
    if form:
        url = url + "%26formId=" + int_to_hashid(form.pk)
    return mark_safe(url)
