#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11720 2019-09-23 06:12:17Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-09-23 14:12:17 +0800 (週一, 23 九月 2019) $
# $Revision: 11720 $

from django.db import models
from jsonfield import JSONField

class Email(models.Model):
    email = models.EmailField()
    fromUrl = models.URLField(max_length=400)
    date = models.DateTimeField(
        auto_now_add=True)

    data = JSONField(null=True, blank=True, default={})
        
    def __unicode__(self):
        return u"%s From: %s (%s)" % (self.email, self.fromUrl, self.date)
        
    def __str__(self):
        return "%s From: %s (%s)" % (self.email, self.fromUrl, self.date)
