#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9992 2017-05-28 14:30:29Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-28 22:30:29 +0800 (週日, 28 五月 2017) $
# $Revision: 9992 $

from django.contrib import admin
from django.utils.translation import ugettext_lazy as _
from django.utils.safestring import mark_safe
from django.template.loader import render_to_string
from django.template import Context

from Zephyrus.boilerplate.models import AdminPlaceholder, BlockDisplayControl

class AdminPlaceholderAdmin(admin.ModelAdmin):
    list_display = (
        'name2', 'page2', 'useGlobalAdminPlaceholder2',
    )
    
    def name2(self, obj):
        return obj.name
        
    def page2(self, obj):
        return obj.page
        
    def useGlobalAdminPlaceholder2(self, obj):
        return obj.useGlobalAdminPlaceholder
        
    name2.short_description = _("Name")
    page2.short_description = _("Page")
    useGlobalAdminPlaceholder2.short_description = \
                                          _("Use Global AdminPlaceholder Value")
    
    
    
    
class BlockDisplayControlAdmin(admin.ModelAdmin):
    list_display = (
        'name2', 'page2', 'display2', 'useGlobalBlockDisplayControl2',
    )
    
    def name2(self, obj):
        return obj.name
        
    def page2(self, obj):
        return obj.page
        
    def display2(self, obj):
        return obj.display
        
    def useGlobalBlockDisplayControl2(self, obj):
        return obj.useGlobalBlockDisplayControl
        
    name2.short_description = _("Name")
    page2.short_description = _("Page")
    display2.short_description = _("Display")
    useGlobalBlockDisplayControl2.short_description = \
                                       _("Use Global BlockDisplayControl Value")

admin.site.register(AdminPlaceholder, AdminPlaceholderAdmin)
admin.site.register(BlockDisplayControl, BlockDisplayControlAdmin)

# Register your models here.
