#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 10552 2017-11-26 08:30:27Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2017-11-26 16:30:27 +0800 (週日, 26 十一月 2017) $
# $Revision: 10552 $

import os
import warnings
import logging

# from django.utils.translation import ugettext_lazy as _

# django.core.exceptions.AppRegistryNotReady: The translation infrastructure 
# cannot be initialized before the apps registry is ready. 
# Check that you don't make non-lazy gettext calls at import time.

from Iuppiter.Util import extendUnique
from Iuppiter.DjangoUtil import extendInstalledApps

def createLogger(name, fileHandlerName):
    logger = logging.getLogger(name)
    logger.setLevel(logging.DEBUG)
    handler = logging.StreamHandler()
    handler.setFormatter(
        logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
    logger.addHandler(handler)
    fileHandler = logging.FileHandler(fileHandlerName)
    fileHandler.setLevel(logging.WARNING)
    logger.addHandler(fileHandler)
    return logger

def update(settingsDict, defaults, config=None):
    """
    Update settings by defaults if the key is not in settings.
    
    @param settingsDict Settings dict.
    @param defaults Defaults dict to provide default value.
    @param config Reserved.
    """
    for k, v in defaults.items():
        if k not in settingsDict:
            settingsDict[k] = v

def warnWithout(k, settingsDict, defaults):
    """
    Prompt warning message for without certain key in settings
    while doing attachSettings.
    
    @param k Settings key.
    @param settingsDict Settings dict.
    @param defaults Defaults dict to provide default value.
    """
    if k not in settingsDict:
        warnings.warn("'%s' %s %s" % (
            colored(k, 'yellow', attrs=['bold']),
            colored(" not set in settings.py, it will be set as ", 'white',
                    attrs=['bold']),
            colored(defaults[k], 'cyan', attrs=['bold'])))

def attachSettings(settingsDict):

    #=========================================================================
    # Django plugins.
    ADDING_INSTALLED_APPS = (
        'djangocms_history',
        'djangocms_forms',
        'Zephyrus.boilerplate',
        'Zephyrus.landing',
        'Zephyrus.facebook',
        'drip',
        'Zephyrus.drip2',
    )

    installed = settingsDict['INSTALLED_APPS']
    keys = [k for k in installed if k.startswith('djangocms_')]
    extendInstalledApps(settingsDict, ADDING_INSTALLED_APPS,
                        key=list(keys)[-1])
    
    #=========================================================================
    # Django CMS Ckeditor.
    DEFAULT_CKEDITOR_SETTINGS = {
        'CKEDITOR_SETTINGS': {
            'language': '{{ language }}',
            'toolbar_CMS': [
                ['cmsplugins',],
                
                ['Source', '-', 'Save', 'NewPage', 'DocProps', 'Preview', 
                 'Print', '-', ' Templates'],
                ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 
                 'Undo', 'Redo'],
                ['Find', 'Replace', '-', 'SelectAll', '-', 'SpellChecker', 
                 'Scayt'],
                ['Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 
                'Button', 'ImageButton', 'HiddenField'],
                ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 
                'Superscript', '-', 'RemoveFormat'],
                ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 
                'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 
                'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl'],
                ['Link', 'Unlink', 'Anchor'],
                ['Image', 'Flash', 'Table', 'HorizontalRule', 'Smiley', 
                'SpecialChar', 'PageBreak', 'Iframe'],
                ['Styles', 'Format', 'Font', 'FontSize'],
                ['TextColor', 'BGColor'],
                ['Maximize', 'ShowBlocks', '-', 'About'],
            ],
            'skin': 'moono',
        },
        'TEXT_ADDITIONAL_TAGS': (
            'iframe',
        ),
        'TEXT_ADDITIONAL_ATTRIBUTES': (
            'scrolling', 'allowfullscreen', 'frameborder'
        ),
    }
    update(settingsDict, DEFAULT_CKEDITOR_SETTINGS)

    #=========================================================================
    # Django CMS Snippe.
    DEFAULT_SNIPPE_SETTINGS = {
        'DJANGOCMS_SNIPPET_SEARCH': True,
    }
    update(settingsDict, DEFAULT_SNIPPE_SETTINGS)

    #=========================================================================
    # Zephyrus Landing.
    LANDING_FORM_SETTINGS = [
        ('djangocms_forms/form_template/default.html', 'Default'),
        ('landing/LandingForm.html', 'Landing Form'),
    ]

    LANDING_CMS_TEMPLATES = [
        ('landing/ThankYou.html', 'Landing Thank You Page'),
    ]

    if 'DJANGOCMS_FORMS_TEMPLATES' in settingsDict:
        formTemplates = settingsDict['DJANGOCMS_FORMS_TEMPLATES']
    else:
        formTemplates = LANDING_FORM_SETTINGS

    if 'CMS_TEMPLATES' in settingsDict:
        cmsTemplates = settingsDict['CMS_TEMPLATES']
    else:
        cmsTemplates = LANDING_CMS_TEMPLATES


    settingsDict['DJANGOCMS_FORMS_TEMPLATES'] = extendUnique(
        formTemplates, LANDING_FORM_SETTINGS)
    settingsDict['CMS_TEMPLATES'] = extendUnique(
        cmsTemplates, LANDING_CMS_TEMPLATES)
    
