#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_plugins.py 11069 2018-05-21 10:18:52Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-21 18:18:52 +0800 (週一, 21 五月 2018) $
# $Revision: 11069 $

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.utils.translation import ugettext as _
from django.template.loader import select_template
from django.db.models import Q
from aldryn_newsblog.models import Article

from Zephyrus.blog_extension import settings as _settings
from Zephyrus.blog_extension.models import FilterPlugin

class FilterArticlePlugin(CMSPluginBase):
    model = FilterPlugin
    module = 'News & Blog'
    name = _("Filter Articles")
    render_template =_settings.ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            _settings.ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES,
        ])

    def render(self, context, instance, placeholder):
        queryset = Article.objects.all()

        if instance.filterMethod == 'or':
            tagList = [tag.name for tag in instance.tag.all()]
            if tagList:
                queryset = queryset.filter(tags__name__in=tagList)
        else:
            for tag in instance.tag.all():
                queryset = queryset.filter(tags__name=tag.name)

        if instance.catagory:
            queryset = queryset.filter(
                categories__in=[instance.catagory])

        if queryset.count() >= instance.limit:
            articles = queryset[:instance.limit]
        else:
            articles = queryset

        clearArticle = []
        for article in articles:
            if not article in clearArticle:
                clearArticle.append(article)

        context.update({
            'articles': clearArticle,
        })
        return context

plugin_pool.register_plugin(FilterArticlePlugin)