#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

class settings(object):
    ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE = \
        "cms_oscar/Featured.html"
    ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE = \
        "cms_oscar/Latest.html"

    ZEPHYRUS_OSCAR_FEATURED_TEMPLATES = [
        (ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE, _("Default")),
    ]

    ZEPHYRUS_OSCAR_LATEST_TEMPLATES = [
        (ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'ZEPHYRUS_OSCAR_FEATURED_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_OSCAR_FEATURED_TEMPLATES:
            if not ele[0] == ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE:
                ZEPHYRUS_OSCAR_FEATURED_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_OSCAR_LATEST_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_OSCAR_LATEST_TEMPLATES:
            if not ele[0] == ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE:
                ZEPHYRUS_OSCAR_LATEST_TEMPLATES.append(ele)

