#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 10982 2018-04-16 08:14:06Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-04-16 16:14:06 +0800 (週一, 16 四月 2018) $
# $Revision: 10982 $

import os

from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from mptt.models import MPTTModel, TreeForeignKey

# 可加 redo ondo

# mptt 樹狀結構

# 不只 static、也能改 template(當然要隱藏別讓客戶看到)

# checksum

# template 可能有版本控制問題


TYPE_CHOICES = (
    ('file', 'File'),
    ('folder', 'Folder'),
)

class Static(MPTTModel):
    type = models.CharField(max_length=6, choices=TYPE_CHOICES)
    name = models.CharField(max_length=50)
    parent = TreeForeignKey(
        'self', 
        on_delete=models.CASCADE, 
        null=True, 
        blank=True, 
        related_name='children')

    class MPTTMeta:
        order_insertion_by = ['name']

    @property
    def path(self):
        path = ''

        ancestors = self.get_ancestors()
        for ancestor in ancestors:
            path = os.path.join(path, ancestor.name)
        path = os.path.join(path, self.name)

        return path

    @property
    def absolutePath(self):
        path = self.path
        
        # FIXME: deploy maybe unwork. 
        fullPath = os.path.join(settings.STATICFILES_DIRS[0], path)

        return fullPath

    def __str__(self):
        return "%s" % (self.name,)

class Template(MPTTModel):
    type = models.CharField(max_length=6, choices=TYPE_CHOICES)
    name = models.CharField(max_length=50)
    parent = TreeForeignKey(
        'self', 
        on_delete=models.CASCADE, 
        null=True, 
        blank=True, 
        related_name='children')

    class MPTTMeta:
        order_insertion_by = ['name']

    @property
    def path(self):
        path = ''

        ancestors = self.get_ancestors()
        for ancestor in ancestors:
            path = os.path.join(path, ancestor.name)
        path = os.path.join(path, self.name)

        return path

    @property
    def absolutePath(self):
        path = self.path
        
        # FIXME: settings.TEMPLATES[0]['DIRS'][0] maybe undefined
        fullPath = os.path.join(settings.TEMPLATES[0]['DIRS'][0], path)
        
        return fullPath

    def __str__(self):
        return "%s" % (self.name,)

    
    