#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 11616 2019-06-07 02:15:46Z Andy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2019-06-07 10:15:46 +0800 (週五, 07 六月 2019) $
# $Revision: 11616 $

from django.conf.urls import url

from Theophrastus.cloud import views

urlpatterns = [
    url(r'^bounces/$', views.getBounces,
        name='Theophrastus.cloud.getBounces'),
    url(r'^complains/$', views.getComplains,
        name='Theophrastus.cloud.getComplains'),
    url(r'^deliveries/$', views.getDeliveries,
        name='Theophrastus.cloud.getDeliveries'),
    url(r'^verify/$', views.verifyEmailAddress,
        name='Theophrastus.cloud.ajax.verifyEmailAddress'),
    url(r'^verify/delete/$', views.deleteVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.deleteVerifiedEmailAddress'),
    url(r'^verify/check/$', views.checkVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.checkVerifiedEmailAddress'),

    url(r'^notificationTopic/set/$', views.setNotificationTopic,
        name='Theophrastus.cloud.ajax.setNotificationTopic'),
    
    # resend error contact.
    url(r'^newsletters/resend/(?P<newsletterId>\w+)',
        views.resendErrorContact, name='resendErrorContact'),
    # view error details
     url(
        r'^tracking/historic/(?P<slug>[-\w]+)/errors/'
        r'(?P<contactMailingStatusId>\w+)',
        views.viewErrorDetails,
        name='Theophrastus.cloud.views.viewErrorDetails'),

]
