/**
$Id: Customization.js 9579 2016-03-09 01:43:46Z Judy $

Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.

Licensed under the Proprietary License, 
you may not use this file except in compliance with the License.
You may obtain a copy of the License at our web site.

See the License for the specific language governing permissions and
limitations under the License.

$Author: Judy $
$Date: 2016-03-09 09:43:46 +0800 (週三, 09 三月 2016) $
$Revision: 9579 $
*/

// Here you can see the function named addButtonCallback referenced above in 
// our widget.
var tinymceEditorSettings = {
    editorId: "",
    
    isFullscreen: function() {
        if (this.editorId == "mce_fullscreen") {
            var obj = django.jQuery('#' + this.editorId + '_toolbargroup');
            if (obj.length > 0) {
                return true;
            }
            else {
                this.editorId = 'id_content';
            }
        }
        return false;
    }
};

function hideButtons() {
    if (tinymceEditorSettings.isFullscreen()) {
        return false;
    }
    var id = tinymceEditorSettings.editorId;
    var mceToolbar = django.jQuery('#' + id + '_toolbargroup table.mceToolbar');
    mceToolbar.each(function() {
        if (this.id == id + '_toolbar1') {
            return;
        }
        django.jQuery(this).hide();
        
    });
    django.jQuery('#id_content_moreButton').show();
};

function showButtons() {
    if (tinymceEditorSettings.isFullscreen()) {
        return false;
    }
    var id = tinymceEditorSettings.editorId;
    var mceToolbar = django.jQuery('#' + id + '_toolbargroup table.mceToolbar');
    mceToolbar.each(function() {
        if (this.id == id + '_toolbar1') {
            return;
        }
        django.jQuery(this).show();
        
    });
    django.jQuery('#id_content_moreButton').hide();
};

function addButtonCallback(ed) {
    ed.onInit.add(function(ed) {
        tinymceEditorSettings.editorId = ed.id;
        if (!tinymceEditorSettings.isFullscreen()) {
            hideButtons();
        }
    });

    // Add a custom button
    ed.addButton('minimizeButton', {
        title : 'Minimize..',
        image : '/static/images/tinymce/MinimizeButton.gif',
        onclick : function() {
			// Add you own code to execute something on click
			// here you can put some code, call other functions, etc...
            hideButtons();
        }
    });
    
    ed.addButton('moreButton', {
        title : 'More..',
        image : '/static/images/tinymce/MoreButton.gif',
        onclick : function() {
			// Add you own code to execute something on click
			// here you can put some code, call other functions, etc...
            showButtons();
        }
    });
}

/*$().ready(function() {
    console.log($('#id_content_variablePlugin'));
    $('#id_content_variablePlugin').parent('td').hide();
});*/