#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Web.py 9165 2016-05-16 06:40:31Z Yachu $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Yachu $
# $Date: 2013-05-14 19:26:54 +0800$
# $Revision: 9165 $
"""
Test django web utitilies.
"""

from Iuppiter import test as util
import os
import sys

def runTestServer(path='.', settings='settings', port=7788, fixtures=None, 
                  dummy=False, noInput=False, timeout=30):
    """
    Run test server.
    See more on django doc:
    https://docs.djangoproject.com/en/1.8/ref/
    django-admin/#testserver-fixture-fixture

    @param path Path of manage.py.
    @param settings Filename of django settings. 
    @param port Server port.
    @param fixtures The fixtures you want to load.
    @param dummy If true, we do nothing, this is for debugging.
    @return Server process (support with statement).
    """
    projectPath = os.path.abspath(path)
    python = sys.executable
    
    if dummy:
        class Dummy(object):
            def __init__(self):
                self.process = None
                self.pid = 0
            def __enter__(self):
                pass
            def __exit__(self, type, value, traceback):
                pass
        return Dummy()
    
    os.chdir(projectPath)
    #os.system("python manage.py runserver 7788")

    fixturesStr = " "
    if fixtures:
        fixturesStr = fixturesStr.join(fixtures)

    import subprocess
    env = os.environ.copy()
    env.pop('DJANGO_SETTINGS_MODULE', None)
    env.setdefault('DJANGO_SETTINGS_MODULE', settings)

    arguments = "--addrport=%d %s" % (port, fixturesStr)
    if noInput:
        arguments = "--addrport=%d --noinput %s" % (port, fixturesStr)
    serverProcess = subprocess.Popen(
        "{python} manage.py testserver {arguments}".format(
          python=python, arguments=arguments),
        stdin=subprocess.PIPE, env=env)

    # Wait for connection and django server to validate database.
    import urllib.request, urllib.parse, urllib.error
    def tryConnect():
        try:
            f = urllib.request.urlopen('http://127.0.0.1:%d/' % port)
            if f.getcode() != 200:
                return False
            return True
        except IOError as e:
            return False

    import time
    elapsed = 0
    now = time.time()
    while tryConnect() is False:
        elapsed = time.time() - now
        if elapsed > timeout:
            killTestServer(serverProcess)
            raise RuntimeError('Unable to start server? Timeout!')

    if serverProcess.poll() == None:
        print("Server started")
        util.chdirToRootDir()

    class ServerProcess(object):
        """
        A server process wrapper to support with statement.
        """
        def __init__(self, process):
            self.process = process
            self.pid = process.pid
        def __enter__(self):
            pass
        def __exit__(self, type, value, traceback):
            killTestServer(self.process)

    return ServerProcess(serverProcess)

def killTestServer(serverProcess):
    """
    Kill test server process.

    @param serverProcess Server process.
    """
    # Python 2.6 and above:
    serverProcess.terminate()
