#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ServiceTest.py 9461 2015-10-26 14:19:39Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Eric $ (last)
# $Date: 2015-10-26 22:19:39 +0800 (Mon, 26 Oct 2015) $
# $Revision: 9461 $

# from Iuppiter.tests import  util
# 
# util.chdirToRootDir()

import unittest

from Iuppiter.Service import BaseService
from Iuppiter.Service import serviceGetter

class TestService(BaseService):

    def __init__(self):
        BaseService.__init__(self)

class ServiceGetterTest(unittest.TestCase):
    """
    Test case for ServiceGetter.
    """

    def testServiceGetter(self):
        """
        Test for ServiceGetter.
        """
        g = serviceGetter

        # Automatically registered.
        self.assertTrue(hasattr(g, 'getTestService'))
        self.assertFalse(g.register(TestService))

        srv = g.get("TestService")
        self.assertTrue(isinstance(srv, TestService))

        self.assertTrue(g.register(TestService, "TestService2"))
        self.assertEqual(id(g.get("TestService2")), id(srv))

        try:
            g.get("TestService3")
            self.fail()
        except:
            pass

        self.assertTrue(g.unregister(name="TestService2"))

        try:
            g.get("TestService2")
            self.fail()
        except:
            pass

        self.assertTrue(g.unregister(TestService))

        self.assertTrue(g.register(TestService, "TestServiceXX"))
        self.assertEqual(id(srv), id(g.getTestServiceXX()))
        self.assertTrue(g.unregister(name="TestServiceXX"))

        self.assertTrue(g.register(TestService))
        self.assertEqual(id(srv), id(g.getTestService()))

from Iuppiter.tests import models

import types
Model = types.ModuleType('Iuppiter.tests.models')
Model.__dict__['TestModel2'] = models.TestModel2

del models.TestModel2

class TestModelManagedService(BaseService):
    def __init__(self):
        BaseService.__init__(self, models)

class TestModelManagedService2(BaseService):
    def __init__(self):
        BaseService.__init__(self, (models, Model))

class ServiceBaseTest(unittest.TestCase):
    """
    Test case for ServiceBase.
    """

    def testAutogenMethods(self):
        """
        Test for auto generated methods which manages models.
        """
        srv = TestModelManagedService.getInstance()

        self.assertTrue(hasattr(srv, 'createTestModel'))

        srv = TestModelManagedService2.getInstance()

        self.assertTrue(hasattr(srv, 'createTestModel'))
        self.assertTrue(hasattr(srv, 'createTestModel2'))

        self.assertTrue(hasattr(srv, 'checkTestModel2Exist'))

    def testAutogenReferences(self):
        srv = TestModelManagedService.getInstance()
        self.assertTrue(hasattr(srv, 'TestModel'))

if __name__ == '__main__':
    unittest.main()
