#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: EncryptionTest.py 1988 2009-10-23 11:15:21Z Bear $
#
# Copyright (c) 2009 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Bear $
# $Date: 2009-10-23 19:15:21 +0800 (週五, 23 十月 2009) $
# $Revision: 1988 $
"""
Test all debug utilities.
"""

import unittest
import time

import Iuppiter.tests

from bs4 import BeautifulSoup
from django.test.client import Client

from Iuppiter.debug import timeit, cp
from Iuppiter.debug.urls import urlpatterns as debugUrls


class DebugTest(unittest.TestCase):
    """
    Test case for Debug.
    """

    def setUp(self):
        self.client = Client()


    def testTimeIt(self):

        def f1():
            time.sleep(0.1)

        t1f = timeit(1, None)(f1)
        t1f()
        usedTime = t1f.elapsed

        self.assertTrue(0.05 < usedTime < 0.15)

        def f2():
            time.sleep(0.2)

        t2f = timeit(2, None)(f2)
        t2f()
        usedTime = t2f.elapsed
        self.assertTrue(0.35 < usedTime < 0.45)

        self.assertTrue(cp(f1, f2, returnResult=True))
        # f1 is faster than f2

    def testExec(self):
        urlpatterns = Iuppiter.tests.urlpatterns
        urlpatterns.extend(debugUrls)

        response = self.client.post('/exec/', data={'code': 'a=1'})

        soup = BeautifulSoup(response.content, 'html.parser')
        tableText = soup.find('table').text.replace('\n', '')

        self.assertTrue(tableText == 'a:1')

    def testThreads(self):
        urlpatterns = Iuppiter.tests.urlpatterns
        urlpatterns.extend(debugUrls)

        response = self.client.get('/threads/')

        soup = BeautifulSoup(response.content, 'html.parser')
        firstRow = soup.find('table').find('tr')

        self.assertTrue('MainThread' in firstRow.text)

if __name__ == '__main__':
    unittest.main()
