#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11489 2019-04-24 06:45:44Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-04-24 15:45:44 +0900 (週三, 24 四月 2019) $
# $Revision: 11489 $

from django.contrib import admin

from Zephyrus.comment.models import Comment

@admin.register(Comment)
class CommentAdmin(admin.ModelAdmin):
    model = Comment
    
    readonly_fields = [
        'url', 'user', "email", 'message', 'createDate']
        
    list_display = ['url', 'user', "email", 'createDate', 'display']
    
    search_fields = ['url',]
