#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11489 2019-04-24 06:45:44Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-04-24 15:45:44 +0900 (週三, 24 四月 2019) $
# $Revision: 11489 $

import datetime

from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _
from cms.models import CMSPlugin

from Zephyrus.comment import settings as _settings

class CommentPlugin(CMSPlugin):
    useFbComment = models.BooleanField(_('Use Facebook Comment'))

    renderTemplate = models.CharField(
        _('Comment Template'), max_length=150,
        choices=_settings.ZEPHYRUS_COMMENT_TEMPLATES,
        default=_settings.ZEPHYRUS_COMMENT_DEFAULT_TEMPLATE,
    )

class RecentResponsePlugin(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    renderTemplate = models.CharField(
        _('Comment Template'), max_length=150,
        choices=_settings.ZEPHYRUS_RECENTRESPONSE_TEMPLATES,
        default=_settings.ZEPHYRUS_RECENTRESPONSE_DEFAULT_TEMPLATE,
    )

class Comment(models.Model):
    url = models.CharField(max_length=400, editable=False, null=True)
    
    user = models.ForeignKey(settings.AUTH_USER_MODEL, null=True, blank=True)
    email = models.EmailField(max_length=254, null=True, blank=True)

    message = models.TextField()

    createDate = models.DateTimeField(auto_now_add=True)
    display = models.BooleanField(default=True)
    
    @property
    def username(self):
        if self.user:
            return self.user.username
        else:
            return self.email

class CommentConfig(models.Model):
    url = models.CharField(max_length=400, editable=False, null=True)
    useFbComment = models.BooleanField(_('Use Facebook Comment'))