#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 9579 2016-03-09 01:43:46Z Judy $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-03-09 09:43:46 +0800 (三, 09  3 2016) $
# $Revision: 9579 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

class Header(models.Model):

    content = models.TextField(
        _('Header content'), blank=True, null=True,
        help_text=_('Custom your header content.'))

    def __unicode__(self):
        return _('Header %s') % str(self.id)

    class Meta:
        verbose_name = _('Header')
        verbose_name_plural = _('Headers')

class Footer(models.Model):

    content = models.TextField(
        _('Footer content'), blank=True, null=True,
        help_text=_('Custom your footer content.'))

    def __unicode__(self):
        return _('Footer %s') % str(self.id)

    class Meta:
        verbose_name = _('Footer')
        verbose_name_plural = _('Footers')
