#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Nuwa.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

from Iuno import PRODUCTION

from Iuno.cloud.backend import Nuwa
from Iuno.cloud.queue.backend import BackendMixin

class Backend(Nuwa.Backend, BackendMixin):

    def __init__(self, context=None, config=None):
        super(Backend, self).__init__(context, config)

        if context and context.get('SERVER_MODE', None) == PRODUCTION:
            self.preferredDomains = (
                'mq.nuwainfo.com',
            )
        else: # STAGE and DEVELOPMENT
            self.preferredDomains = (
                'chocobo.servehttp.com',
                'mq.nuwainfo.com',
            )
