#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Util.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

import hashlib

from collections import OrderedDict
from urllib import urlencode

# ​https://github.com/vinta/python-pay2go

class Pay2GoMPGAPI(object):

    def __init__(self, hashKey, hashIv, sandbox, *args, **kwargs):
        self.hashKey = hashKey
        self.hashIv = hashIv
        if sandbox:
            self.ApiUrl = 'https://ccore.spgateway.com/MPG/mpg_gateway'
        else:
            self.ApiUrl = 'https://core.spgateway.com/MPG/mpg_gateway'

        self.requiredFields = (
            'Amt',
            'MerchantID',
            'MerchantOrderNo',
            'TimeStamp',
            'Version',
        )

    def buildFormData(self, data):
        def generateCheckValue(data):
            orderedDict = OrderedDict()

            orderedDict['HashKey'] = self.hashKey
            for field in self.requiredFields:
                orderedDict[field] = data[field]
            orderedDict['HashIV'] = self.hashIv

            checkValue = hashlib.sha256(
                urlencode(orderedDict).encode('utf-8')).hexdigest().upper()

            return checkValue

        formData = dict(data)
        formData['CheckValue'] = generateCheckValue(data)

        return formData

    def createPayment(self, data):
        payment = Payment(
            formAction=self.ApiUrl,
            formData=self.buildFormData(data)
        )

        return payment


class Payment(object):

    def __init__(self, formAction, formData, *args, **kwargs):
        self.formAction = formAction
        self.formData = formData