#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11194 2018-08-06 06:07:46Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License, 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and 
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-08-06 15:07:46 +0900 (週一, 06 八月 2018) $
# $Revision: 11194 $ 

import json
import logging

from django.views.decorators.csrf import csrf_exempt
from django.utils.decorators import method_decorator
from django.shortcuts import redirect
from django.contrib import messages
from django.views import generic
from django.utils.translation import ugettext as _
from django.conf import settings
from paypal.express.views import SuccessResponseView
from oscar.core.loading import get_model, get_class

from Iuno.shop import forms
from Iuno.shop import buildAPIForm
from Iuno.shop.models import ECPayTrade, AllPayTrade, SpgatewayTrade

_PaymentDetailsView = get_class('checkout.views', 'PaymentDetailsView')

Source = get_model('payment', 'Source')
SourceType = get_model('payment', 'SourceType')
Basket = get_model('basket', 'Basket')

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
logger.addHandler(logging.StreamHandler())

SPGATEWAY = 'spgateway'
ALLPAY = 'allpay'
ECPAY = 'ecpay'
    
class SuccessResponseView(SuccessResponseView):
    def get_shipping_address(self, basket):
        return PaymentDetailsView.get_shipping_address(self, basket)

# patch
from oscar.apps.checkout import views

def get_context_data(self, **kwargs):
    kwargs = super(views.PaymentDetailsView, self).get_context_data(**kwargs)
    
    submission = self.build_submission()

    ecpayEnable = False
    if hasattr(settings, 'IUNO_SHOP_ECPAY_ENABLE'):
        ecpayEnable = settings.IUNO_SHOP_ECPAY_ENABLE

    allpayEnable = False
    if hasattr(settings, 'IUNO_SHOP_ALLPAY_ENABLE'):
        allpayEnable = settings.IUNO_SHOP_ALLPAY_ENABLE

    spgatewayEnable = False
    if hasattr(settings, 'IUNO_SHOP_SPGATEWAY_ENABLE'):
        spgatewayEnable = settings.IUNO_SHOP_SPGATEWAY_ENABLE
    
    if ecpayEnable:
        kwargs['ecpay'] = buildAPIForm(submission, self.request, 'ecpay')
    if allpayEnable:
        kwargs['allpay'] = buildAPIForm(submission, self.request, 'allpay')
    if spgatewayEnable:
        kwargs['spgateway'] = buildAPIForm(
                                        submission, self.request, 'spgateway')
    
    return kwargs

views.PaymentDetailsView.get_context_data = get_context_data

class SuccessResponseView2(_PaymentDetailsView):
    preview = True
    http_method_names = ['post',]
    
    @method_decorator(csrf_exempt)
    def dispatch(self, request, *args, **kwargs):
        return super(SuccessResponseView2, self).dispatch(request, 
                                                         *args, **kwargs)
    
    def post(self, request, *args, **kwargs):
        # apiName
        self.apiName = kwargs['name']

        if not self.apiName in [SPGATEWAY, ALLPAY, ECPAY]:
            raise ValueError("Not pay api name: %s" % apiName)

        if self.apiName in [ALLPAY, ECPAY]:
            # data
            self.tradeNo = request.POST.get('TradeNo')
            self.tradeAmt = request.POST.get('TradeAmt')
            self.merchantID = request.POST.get('MerchantID')
            self.merchantTradeNo = request.POST.get('MerchantTradeNo')
            self.rtnCode = request.POST.get('RtnCode')
            self.rtnMsg = request.POST.get('RtnMsg')
            self.payAmt = request.POST.get('MerchantID')
            self.tradeDate = request.POST.get('TradeDate')
            self.paymentType = request.POST.get('PaymentType')
            self.simulatePaid = request.POST.get('SimulatePaid')
            self.paymentDate = request.POST.get('PaymentDate')
            self.paymentTypeChargeFee = request.POST.get('PaymentTypeChargeFee')

            # basket
            index = request.POST.get('MerchantTradeNo').find('BASKETID')
            self.basketId = int(request.POST.get('MerchantTradeNo')[index + 8:])

            # error
            if self.rtnMsg == 'ERROR':
                msg = _("There was an error in the payment. Please try again.")
                messages.warning(self.request, msg)
                logger.error('%s API ERROR: %s' % (self.apiName, request.POST))
                return redirect('checkout:shipping-address')
        
            # record trade data
            if self.apiName == ECPAY:
                ecpayTrade = ECPayTrade.objects.create(
                    tradeNo=self.tradeNo,
                    tradeAmt=int(self.tradeAmt),
                    merchantId=self.merchantID,
                    merchantTradeNo=self.merchantTradeNo,
                    rtnCode=self.rtnCode,
                    payAmt=int(self.payAmt),
                    tradeDate=self.tradeDate.replace('/', '-'),
                    paymentType=self.paymentType,
                    simulatePaid=self.simulatePaid,
                    paymentDate=self.paymentDate.replace('/', '-'),
                    paymentTypeChargeFee=self.paymentTypeChargeFee,
                    rtnMsg=self.rtnMsg,
                )
                ecpayTrade.save()
            else:
                allpayTrade = AllPayTrade.objects.create(
                    tradeNo=self.tradeNo,
                    tradeAmt=int(self.tradeAmt),
                    merchantId=self.merchantID,
                    merchantTradeNo=self.merchantTradeNo,
                    rtnCode=self.rtnCode,
                    payAmt=int(self.payAmt),
                    tradeDate=self.tradeDate.replace('/', '-'),
                    paymentType=self.paymentType,
                    simulatePaid=self.simulatePaid,
                    paymentDate=self.paymentDate.replace('/', '-'),
                    paymentTypeChargeFee=self.paymentTypeChargeFee,
                    rtnMsg=self.rtnMsg,
                )
                allpayTrade.save()
        else:
            # data
            data = json.loads(request.POST.get('JSONData', '{}'))
            
            self.status = data.get('Status')
            self.message = data.get('Message')
            self.result = json.loads(data.get('Result', '{}'))
            self.tradeNo = self.result.get("TradeNo")
            self.tradeAmt = self.result.get("Amt")
            self.merchantID = self.result.get("MerchantID")
            self.merchantTradeNo = self.result.get("MerchantOrderNo")
            self.rtnCode = self.result.get("RespondCode")
            self.tradeDate = self.result.get("PayTime")
            self.paymentMethod = self.result.get("PaymentMethod")
            self.paymentType = self.result.get("PaymentType")
            
            # basket
            index = self.result.get('MerchantOrderNo').find('BASKETID')
            self.basketId = int(self.result.get('MerchantOrderNo')[index + 8:])

            # error
            if not self.status == 'SUCCESS':
                msg = _("There was an error in the payment. Please try again.")
                messages.warning(self.request, msg)
                logger.error('%s API ERROR: %s' % (self.apiName, request.POST))
                return redirect('checkout:shipping-address')

            # record trade data
            spgatewayTrade = SpgatewayTrade.objects.create(
                tradeNo=self.tradeNo,
                tradeAmt=int(self.tradeAmt),
                merchantId=self.merchantID,
                merchantTradeNo=self.merchantTradeNo,
                rtnCode=self.rtnCode,
                paymentDate=self.tradeDate.replace('/', '-'),
                paymentType=self.paymentType,
                paymentMethod=self.paymentMethod,
                rtnMsg=self.message,
            )
            spgatewayTrade.save()
        
        if not self.preview:
            return http.HttpResponseBadRequest()
        return self.handle_place_order_submission(request)
        
        
    def build_submission(self, **kwargs):
        submission = super(
            SuccessResponseView2, self).build_submission(**kwargs)
        
        
        submission['payment_kwargs']['tradeNo'] = self.tradeNo
        submission['payment_kwargs']['tradeAmt'] = self.tradeAmt
        submission['payment_kwargs']['basketId'] = self.basketId
        return submission

    
    def handle_payment(self, order_number, total, **kwargs):
        tradeAmt = int(kwargs['tradeAmt'])
        tradeNo = kwargs['tradeNo']
        source_type, is_created = SourceType.objects.get_or_create(
            name=self.apiName)
        source = Source(source_type=source_type,
                        currency='TWD',
                        amount_allocated=tradeAmt,
                        amount_debited=tradeAmt) 
        
        self.add_payment_source(source)
        self.add_payment_event('Settled', tradeAmt,
                               reference=tradeNo)

class ECPayTransactionListView(generic.ListView):
    model = ECPayTrade
    template_name = 'shop/payment/dashboard/ECPay.html'
    context_object_name = 'transactions'

class AllPayTransactionListView(generic.ListView):
    model = AllPayTrade
    template_name = 'shop/payment/dashboard/AllPay.html'
    context_object_name = 'transactions'

class SpgatewayTransactionListView(generic.ListView):
    model = SpgatewayTrade
    template_name = 'shop/payment/dashboard/Spgateway.html'
    context_object_name = 'transactions'
        
    


