var $j = jQuery.noConflict();

// Fix img tag attributes lost after pluginize.
// =============================================================================

var findComments = function(el) {
    var arr = [];
    for(var i = 0; i < el.childNodes.length; i++) {
        var node = el.childNodes[i];
        if(node.nodeType === 8) {
            arr.push(node);
        } else {
            arr.push.apply(arr, findComments(node));
        }
    }
    return arr;
};

var walkDOM = function (node, tag) {
        if(node.nodeName.toUpperCase() == tag.toUpperCase()){
            return node
        };
        node = node.firstChild;
        while(node) {
            var result = walkDOM(node, tag);
            if (result){
                return result;
            };
            node = node.nextSibling;
        };
};    

var findTargetNode = function(commentNodes, commentStr, tag){
    var target;
    for(i in commentNodes){
        if(commentNodes[i].nodeValue == commentStr){
            node = commentNodes[i].nextSibling;
            while(node){
                var result = walkDOM(node, tag);
                if (result){
                    return result;
                } else {
                    node = node.nextSibling
                };
            };
        };
    };
    return null;
};

var addAttrs = function(target, attrs){
    $target = $j(target);
    for(k in attrs){
        if(k == 'class'){
            var origin = $target.attr('class');
            $target.attr('class', origin + ' ' + attrs[k]);
        }else{
            $target.attr(k, attrs[k]);
        };
    };
};


$j(document).ready(function() {
    var commentNodes = findComments(document);
    
    // Add Attr to tag

    {% for tag in tagList %}
        var {{ tag.tag }}{{ tag.md5 }} = findTargetNode(commentNodes, 'CMS:{{ tag.name }}', '{{ tag.tag }}');
        if({{ tag.tag }}{{ tag.md5 }} != null){  
            var attrs{{ tag.md5 }} = {
                {% for attr in tag.attrList %}
                    '{{ attr.name }}': '{{ attr.value }}'{% if not forloop.last%},{% endif %}
                {% endfor %}
            };
            addAttrs({{ tag.tag }}{{ tag.md5 }}, attrs{{ tag.md5 }})
        };
    {% endfor %}
});

// =============================================================================

// Fix Django CMS edit mode issues #2792.
// =============================================================================

$j(document).ready(function() {
    var toAppendDiv = $j('div.cms-placeholder');  
    $j('._cmsCollection').append(toAppendDiv);  
    var toAppendScript = $j("script[id|='cms-plugin-child-classes']");  
    $j('._cmsCollection').append(toAppendScript);
    
    var commentNodes = findComments(document);
    
    for(var j = 0;j < commentNodes.length; j++) {
        if(commentNodes[j].nodeValue.substring(
            0, 'cmsboilerplatetagstart=p'.length
            ) == 'cmsboilerplatetagstart=p') {
            var p = null;
            var next = commentNodes[j].nextSibling;
            while(!p && next){
                if(next.nodeName.toUpperCase() == 'P') {
                    var p = next;
                } else {
                    next = next.nextSibling;
                }
            };
            
            if(p){
                console.log(p);
                var jp = $j(p);
                
                var comment = null;
                var next = p;
                var tagList = [];
                while(! comment){
                    next = next.nextSibling;
                    if(next.nodeValue == 'cmsboilerplatetagend=p') {
                        comment = next;
                    } else {
                        tagList.push(next);
                    };
                };
                
                console.log(tagList);
                
                for(var i = 0;i < tagList.length; i++) {
                    p.appendChild(tagList[i]);
                };   
                
                var lastChild = jp.children().last();
                if($j.trim(lastChild.html()) == '' & 
                   lastChild.prop("tagName") == 'P') {
                    lastChild.remove();
                };
            };  
        };
    };
});

// =============================================================================

// Fix template use js to render link #2982.
// =============================================================================
$j(document).ready(function() {
    var allLink = $j('link').each(function(index) { 
        var href = $j(this).attr('href')
        if(!(href.substring(0, 8) == "/static/") & 
           !(href.substring(0, 4).toLowerCase() == "http")){
            if(href.substring(0, 1) == "/"){
                $j(this).attr('href', '/static' + $j(this).attr('href'));
            } else {
                $j(this).attr('href', '/static/' + $j(this).attr('href'));
            };
        };
    });
});