#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: settings.py 9634 2016-04-13 08:13:53Z Eric $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-13 16:13:53 +0800 (Wed, 13 Apr 2016) $
# $Revision: 9634 $

import os
import sys

#============================================================================
# Production or Debug mode.

DEVELOPMENT = 1
STAGE = 2
PRODUCTION = 3

SERVER_MODE = DEVELOPMENT
#============================================================================

#============================================================================
# Project settings.

APP_NAME = 'browser'
APP_VERSION = "0.2.0." + "$Revision: 9634 $"[11:-2]

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.admin',
    'Iuppiter.extension',
    'Iuno.cloud.browser',
)

ROOT_URLCONF = 'browser.urls'
#============================================================================

#============================================================================
# Administration.

ADMINS = (
    ('Bear', 'bear@tracedig.com'),
)

# Make this unique, and don't share it with anybody.
SECRET_KEY = '1&xodz2j1ys-b1x8n8_r-r(tsu%9@oem$+50mrvtn42#wjgq(p'
#============================================================================

#============================================================================
# Iuno.cloud.

IUNO_CLOUD_ENABLE = True
IUNO_CLOUD_QUEUE_SETTINGS = {
    'preferred': {
        'Nuwa': ('mq.nuwainfo.com',),
    },
}
IUNO_CLOUD_SERVICES = ('queue', 'mail', 'browser') 

IUNO_CLOUD_LOGGING_FILE = os.path.join(os.path.dirname(__file__), 'browser.log')
#============================================================================

import Iuno
Iuno.attachSettings(locals())

