#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: TheophrastusSettings.py 10388 2017-10-21 15:16:00Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-10-21 23:16:00 +0800 (Sat, 21 Oct 2017) $
# $Revision: 10388 $

import os

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    ('Yachu', 'yachu.jeng@tracedig.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'TEST_NAME': 'test_newsletter.db',
        'NAME': 'newsletter.db', # Or path to database file if using sqlite3.
        'USER': '', # Not used with sqlite3.
        'PASSWORD': '', # Not used with sqlite3.
        'HOST': '', # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '', # Set to empty string for default. Not used with sqlite3.
        'OPTIONS': {
            'timeout': 300, # Make a smaller timeout to increase reaction speed.
        },
    }
}

#SOUTH_DATABASE_ADAPTERS = {
#    'default': "south.db.sqlite3"
#}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Asia/Taipei'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'zh-tw'

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Support languages.
LANGUAGES = (
  ('zh-tw', 'Traditional Chinese'),
  ('en-us', 'English'),
)

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale
USE_L10N = True

# Set locale path.
LOCALE_PATHS = (
    os.path.join(os.path.dirname(__file__), 'locale'),
)

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = os.path.join(os.path.dirname(__file__), 'static')

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = '/static/'

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

TEMPLATE_CONTEXT_PROCESSORS = (
  'django.core.context_processors.auth',
  'django.core.context_processors.i18n',
  'django.core.context_processors.request',
  'django.core.context_processors.media',
  'emencia.django.newsletter.context_processors.media',
)

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.admin',
    'Iuppiter.i18n',
    'Iuppiter.debug',
    'Iuppiter.extension',
    'Iuppiter.test',
    'django_ses',
    'tagging',
    'tinymce',
    'emencia.django.newsletter',
    # 'Theophrastus.editor',
    # 'Theophrastus.statistics',
    # 'Theophrastus.cloud',
    # 'Theophrastus.newsletter_extension',
    # 'Theophrastus.document',
    # 'Theophrastus.integration',
    # 'Theophrastus.api',
    # If your want do translate, you need to enable these:
    # 'editor',
    # 'statistics',
    # 'cloud',
    'newsletter_extension',
    'document',
    'integration',
    # 'api',
)

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'vsm6md#&jt2fcb3zj#7s-@_ij^9&^hos9)h9pgtftxg7^j78#d'
 
TINYMCE_DEFAULT_CONFIG = {
    'plugins':
        "facebook,autolink,lists,spellchecker,pagebreak,style,layer,table,save"
        ",advhr,advimage,advlink,emotions,iespell,inlinepopups,"
        "insertdatetime,preview,media,searchreplace,print,contextmenu,"
        "paste,directionality,fullscreen,noneditable,visualchars,"
        "nonbreaking,xhtmlxtras,template,upload,variablePlugin",
    'relative_urls': False,
    'remove_script_host': False,
    'skin_variant': "black",
    'style_formats': [{
        'title' : 'Bold text',
        'inline' : 'b'
    }, {
        'title' : 'Red text',
        'inline' : 'span',
        'styles' : {'color' : '#ff0000'}
    }, {
        'title' : 'Red header',
        'block' : 'h1',
        'styles' : {'color' : '#ff0000'}
    }],
 
    #'formats': {"test": {"title" : 'Table row 1', "selector" : 'tr', "classes" : 'tablerow1'}},
    'theme': "advanced",
    'theme_advanced_buttons1': "save,newdocument,|,bold,italic,underline,"
                               "strikethrough,|,justifyleft,justifycenter,"
                               "justifyright,justifyfull,|,styleselect,"
                               "formatselect,fontselect,fontsizeselect,"
                               "template,|,link,unlink,image,|,",
    'theme_advanced_buttons2': "cut,copy,paste,pastetext,pasteword,|,search,"
                               "replace,|,bullist,numlist,|,outdent,indent,"
                               "blockquote,|,undo,redo,|,"
                               "upload,cleanup,code,|,insertdate,"
                               "inserttime,preview,|,forecolor,backcolor",
    'theme_advanced_buttons3': "tablecontrols,|,hr,removeformat,visualaid,|,"
                               "sub,sup,|,charmap,iespell,media,advhr,|,"
                               "insertlayer,moveforward,movebackward,absolute,"
                               "|,styleprops,spellchecker,",
    'theme_advanced_buttons4': "fullscreen,print,feed,variablePlugin,|,",
    'theme_advanced_toolbar_location': "top",
    'theme_advanced_toolbar_align': "left",
    'theme_advanced_statusbar_location': "bottom",
    'theme_advanced_resizing': True,
 
    # Skin options
    'skin': "o2k7",
    'skin_variant': "silver",
 
    # Example content CSS (should be your site CSS)
    #'content_css' : "css/example.css",
 
    # Drop lists for link/image/media/template dialogs
    #'template_external_list_url': "%sjs/TemplateExternalList.js" % MEDIA_URL,
    #'external_link_list_url': "js/link_list.js",
    #'external_image_list_url': "js/image_list.js",
    #'media_external_list_url': "js/media_list.js",
 
    # Replace values for the template plugin
    'template_replace_values': {
        'username': "Some User",
        'staffid': "991234"
    },
 
    'template_templates': [],
}

ENABLE_FAKE_MAIL = True
ENABLE_FAKE_SMTP = True
