var $j = jQuery.noConflict();

var findComments = function(el) {
    var arr = [];
    for(var i = 0; i < el.childNodes.length; i++) {
        var node = el.childNodes[i];
        if(node.nodeType === 8) {
            arr.push(node);
        } else {
            arr.push.apply(arr, findComments(node));
        }
    }
    return arr;
};

var findTargetNode = function(commentNodes, commentStr){
    var target;
    for(i in commentNodes){
        if(commentNodes[i].nodeValue == commentStr){
            node = commentNodes[i].nextSibling;
            while(true){
                if(node.nodeName == 'IMG'){
                    return node
                } else {
                    node = node.nextSibling
                }
            };
        };
    };
    return null;
};

var addAttrs = function(target, attrs){
    $target = $j(target);
    for(k in attrs){
        if(k == 'class'){
            var origin = $target.attr('class');
            $target.attr('class', origin + ' ' + attrs[k]);
        }else{
            $target.attr(k, attrs[k]);
        };
    };
};

$j(document).ready(function() {
    var commentNodes = findComments(document);
    
    // Add Attr to Img

    {% for img in imgList %}
        var img{{ img.md5 }} = findTargetNode(commentNodes, 'CMS:{{ img.name }}');
        if(img{{ img.md5 }} != null){  
            var attrs{{ img.md5 }} = {
                {% for attr in img.attrList %}
                    '{{ attr.name }}': '{{ attr.value }}'{% if not forloop.last%},{% endif %}
                {% endfor %}
            };
            addAttrs(img{{ img.md5 }}, attrs{{ img.md5 }})
        };
    {% endfor %}
});