#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: FakeTemplateTags.py 9976 2017-05-16 06:31:28Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-16 14:31:28 +0800 (週二, 16 五月 2017) $
# $Revision: 9976 $

from django import template
from django.utils.safestring import mark_safe
from django.templatetags.static import StaticNode
from cms.templatetags.cms_tags import Placeholder, CMSToolbar
from sekizai.templatetags.sekizai_tags import RenderBlock

register = template.Library()

class Placeholder2(Placeholder):

    lang = 'zh-hant'

    def render_tag(self, context, name, extra_bits, nodelist=None):

        super(Placeholder2, self).render_tag(context, name,
                                                       extra_bits, nodelist)
        return "{% placeholder '" + name + "' %}"
        
        
class StaticNode2(StaticNode):
    def render(self, context):
        return "{% " + self.path.contents + " %}"

register.tag('placeholder', Placeholder2)
register.tag('static', StaticNode2)


