#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: LandingSocial.py 9976 2017-05-16 06:31:28Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-16 14:31:28 +0800 (週二, 16 五月 2017) $
# $Revision: 9976 $

from django import template
from django.utils.safestring import mark_safe
from django.core.urlresolvers import reverse

register = template.Library()

@register.simple_tag
def LandingSocial(request, method, redirectTo=None):
    social = reverse('social:begin', args=[method])
    fromUrl = request.path 
    next = "?next=%s?fromUrl=%s" % (reverse('landing_social'), fromUrl)
    if redirectTo:
        next += ("%26redirectTo=" + redirectTo)
    url = social + next
    return mark_safe(url)
