# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models

def moveErrorMessages(apps, schema_editor):
    ErrorMessageOld = apps.get_model("newsletter_extension", "ErrorMessage")
    ErrorMessageNew = apps.get_model("cloud", "ErrorMessage")
    for msg in ErrorMessageOld.objects.all():
        ErrorMessageNew.objects.create(
            id=msg.id,
            message=msg.message,
            contact=msg.contact,
            newsletter=msg.newsletter
        )

class Migration(migrations.Migration):

    dependencies = [
        ('newsletter_extension', '0004_auto_20171219_1532'),
    ]

    operations = [
        #migrations.RunPython(moveErrorMessages),
        migrations.RemoveField(
            model_name='errormessage',
            name='contact',
        ),
        migrations.RemoveField(
            model_name='errormessage',
            name='newsletter',
        ),
        migrations.DeleteModel(
            name='ErrorMessage',
        ),
    ]
