/**
$Id: Footer.js 9579 2016-03-09 01:43:46Z Judy $

Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.

Licensed under the Proprietary License, 
you may not use this file except in compliance with the License.
You may obtain a copy of the License at our web site.

See the License for the specific language governing permissions and
limitations under the License.

$Author: Judy $
$Date: 2016-03-09 09:43:46 +0800 (週三, 09 三月 2016) $
$Revision: 9579 $
*/

var $ = django.jQuery;
$().ready(function() {
    
    var setDefaultContent = function() {
        $('#loadingMask').show();
        $.getJSON(
            getDefaultFooterTextUrl,
            function (response, textStatus, jqXHR) {
                var content = response.content;
                // set content.
                tinymce.activeEditor.setContent(content);
                $('#loadingMask').hide();
            }
        );
    };
    
    $('<br/><div>' + 
      '<input type="button" id="insertDefault" value="插入預設值" />' + 
      '</div>').insertAfter('#content-main ul');
    
    var checkContent = function(_needConfirm) {
        var content = tinymce.activeEditor.getContent();
        var needConfirm = false;
        if (content != "") {
            needConfirm = true;
        }
        
        if (typeof(_needConfirm) != 'undefined') {
            needConfirm = needConfirm && _needConfirm;
        }
        if (needConfirm) {
            if (!window.confirm("您的內容即將被覆蓋，您確定要繼續嗎？")) {
                return false;
            }
        }
        setDefaultContent();
    };
    
    $('#insertDefault').click(function() {
        checkContent();
    });

    $('#header_form').append(
        '<div id="loadingMask" style="display:none;">Loading</div>');
    
    // Hide buttons.
    $('div.submit-row [name!=_continue]').remove();
    
});
