#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 10806 2018-03-02 04:29:05Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-02 12:29:05 +0800 (Fri, 02 Mar 2018) $
# $Revision: 10806 $

from django.shortcuts import render_to_response, get_object_or_404
from django.contrib.auth.decorators import login_required
from django.template import RequestContext
from django.utils.translation import ugettext_lazy as _

from emencia.django.newsletter.models import Newsletter

@login_required
def viewNewsletterHistoric(request, slug):
    """Display the historic of a newsletter"""
    opts = Newsletter._meta
    newsletter = get_object_or_404(Newsletter, slug=slug)

    context = {'title': _('Historic of %s') % newsletter.__unicode__(),
               'original': newsletter,
               'opts': opts,
               'object_id': newsletter.pk,
               'app_label': opts.app_label}
    return render_to_response('NewsletterHistoric.html',
                              context, context_instance=RequestContext(request))
