#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_app.py 11244 2018-10-10 15:19:58Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-10-11 00:19:58 +0900 (週四, 11 十月 2018) $
# $Revision: 11244 $

import os
import datetime

from django.core.management.base import BaseCommand, CommandError

from Iuno.crawler import STATIC_DIR
from Iuppiter.Logging import createLogger

logger = createLogger(__name__)

class Command(BaseCommand):
    
    help = 'Clean backup.'
    
    def add_arguments(self, parser):
        parser.add_argument('spider', type=str, help="Spider name")
        parser.add_argument('date', type=str, help="Time(year-month-day)")

    def handle(self, *args, **options):
        name = options['spider']
        date = datetime.datetime.strptime(options['date'], '%Y-%m-%d')
        
        # clear backup
        allBackups = []
        
        for backup in os.listdir(STATIC_DIR):
            if backup.endswith(".zip") and backup.startswith("Backup_%s" % name):
                path = os.path.join(STATIC_DIR, backup)
                createTime = datetime.datetime.strptime(backup, 'Backup_' + name + '_%Y-%m-%d.zip')
                allBackups.append((path, createTime))
        
        for backup, createTime in allBackups:
            if date > createTime and os.path.isfile(backup):
                os.remove(backup)
                logger.info("Clean backup file: %s" % backup)


            
                    