#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 10797 2018-03-01 02:31:02Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-01 10:31:02 +0800 (Thu, 01 Mar 2018) $
# $Revision: 10797 $

from django.db import models

from Iuppiter.Model import BaseModelMixin

from emencia.django.newsletter.models import Newsletter, Contact

class CloudMailInformation(models.Model, BaseModelMixin):
    """
    Mail sending information.
    """
    newsletter = models.ForeignKey(Newsletter, unique=False)

    contact = models.ForeignKey(Contact, unique=False)

    # Response id for sent mail.
    messageId = models.TextField(max_length=2048)
    # Response message for sent mail.
    message = models.TextField(default='')

class NewsletterInformation(models.Model, BaseModelMixin):

    newsletter = models.ForeignKey(Newsletter, unique=True)

    sync = models.BooleanField(default=True)

