#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Patch.py 10447 2017-11-06 23:27:59Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-11-07 07:27:59 +0800 (Tue, 07 Nov 2017) $
# $Revision: 10447 $

import types

from django.conf import settings

from emencia.django.newsletter.models import Newsletter

def replaceNewsletterKeyword(content):
    """
    Insert newsletter's site url to Facebook Feed plugin.

    @param content Newsletter's content.
    """

    if (hasattr(settings, 'SECURE_PROXY_SSL_HEADER') and
        settings.SECURE_PROXY_SSL_HEADER):
        protocol = 'https'
    else:
        protocol = 'http'

    s = ("%s://{{ domain }}{%% url 'newsletter_newsletter_contact' " % (
            protocol, ) + 
         "slug=newsletter.slug uidb36=uidb36 token=token %}")
    content = content.replace('ReplaceNewsletterSiteLink', s)

    appId = settings.FACEBOOK_FEED_APP_ID
    content = content.replace('ReplaceFacebookAppId', appId)

    s = ("%s://{{ domain }}{%% url 'Theophrastus.facebook.feed.complete' %%}" %(
            protocol, )
        )
    content = content.replace('ReplaceRedirectUri', s)

    return content

def cleanFields(self, *args, **kwargs):
    if self.pk is None:
        self.content = replaceNewsletterKeyword(self.content)

Newsletter.clean = types.MethodType(cleanFields, None, Newsletter)

