#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 10806 2018-03-02 04:29:05Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-02 12:29:05 +0800 (Fri, 02 Mar 2018) $
# $Revision: 10806 $

from django.conf.urls import url, patterns

from Theophrastus.newsletter_extension import views

urlpatterns = patterns('',
    url(r'^newsletter/header/text/$', views.getDefaultHeaderText,
        name='Theophrastus.views.getDefaultHeaderText'),
    url(r'^newsletter/footer/text/$', views.getDefaultFooterText,
        name='Theophrastus.views.getDefaultFooterText'),
    url(r'^historic/(?P<slug>[-\w]+)/$', views.viewNewsletterHistoric,
        name='Theophtastus.newsletter_extension.viewHistoric'),
    url(r'^slug/get/$', views.getSlugName,
        name="Theophrastus.views.getSlugName"),
    url(r'^mailingList/get/$', views.getMailingListInfo,
        name="Theophrastus.views.getMailingListInfo"),
    
    # resend error contact.
    url(r'^newsletters/resend/(?P<newsletterId>\w+)',
        views.resendErrorContact, name='resendErrorContact'),

    url(
        r'^tracking/historic/(?P<slug>[-\w]+)/errors/'
        r'(?P<contactMailingStatusId>\w+)',
        views.viewErrorDetails,
        name='Theophrastus.newsletter_extension.views.viewErrorDetails'),
)

