#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11314 2018-12-14 05:31:25Z Kevin $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Kevin $ (last)
# $Date: 2018-12-14 13:31:25 +0800 (??, 14 ??? 2018) $
# $Revision: 11314 $

import os

from django.conf import settings

# FIXME: 看 Iuno 該怎麼設定
STATIC_DIR = None
if not settings.DEBUG:
    if hasattr(settings, "STATIC_ROOT"):
        STATIC_DIR = settings.STATIC_ROOT
else:
    if hasattr(settings, "STATICFILES_DIRS"):
        try:
            STATIC_DIR = settings.STATICFILES_DIRS[0]
        except Exception as e:
            pass
        
if not STATIC_DIR:
    STATIC_DIR = os.path.join(settings.BASE_DIR, "static")

TEMPLATE_DIR = None
if hasattr(settings, "TEMPLATES"):
    try:
        TEMPLATE_DIR = settings.TEMPLATES[0]['DIRS'][0]
    except Exception as e:
        pass

if not STATIC_DIR:
    TEMPLATE_DIR = os.path.join(settings.BASE_DIR, "templates")

BACKUP_DIR_NAME = "_Iuno.template_editor_backup" 

BACKUP_FILE_DIR = os.path.join(
    STATIC_DIR, BACKUP_DIR_NAME)

if not os.path.isdir(BACKUP_FILE_DIR):
    os.mkdir(BACKUP_FILE_DIR)

import six

def toBytes(s):
    return s if six.PY2 else s.encode()
