#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 17:31:00 +0800 (Mon, 16 Jul 2018) $
# $Revision: 11172 $

import os

from django.test import TestCase

from Iuno import member

BASE_DIR = '.'
class TestAttachSettings(TestCase):
    
    def testSettingsContent(self):
        
        settingsContent = {
            'AUTHENTICATION_BACKENDS' : (
            ),
            'INSTALLED_APPS' : (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),
            'MIDDLEWARE_CLASSES' : (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                ('django.contrib.auth.middleware.'
                 'SessionAuthenticationMiddleware'),
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),
            'TEMPLATES' : [
                {
                    'BACKEND': ('django.template.backends.django.'
                                'DjangoTemplates'),
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            ('django.contrib.messages.context_processors.'
                             'messages'),
                        ],
                    },
                },
            ],
            'FACEBOOK_APP_ID' : '123', 
            'FACEBOOK_API_SECRET' : '321',
            'GOOGLE_OAUTH2_CLIENT_ID' : '789',
            'GOOGLE_OAUTH2_CLIENT_SECRET' : '987', 
            'DATABASES' : {
                'default': {
                    'ENGINE': 'django.db.backends.sqlite3',
                    'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
                }
            },
            'LOGIN_REDIRECT_URL': '/settings',
        }
        
        settingsContentForHTTP = {'AUTHENTICATION_BACKENDS' : (
            ),
            'INSTALLED_APPS' : (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),
            'MIDDLEWARE_CLASSES' : (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                ('django.contrib.auth.middleware.'
                 'SessionAuthenticationMiddleware'),
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),
            'TEMPLATES' : [
                {
                    'BACKEND': ('django.template.backends.django.'
                                'DjangoTemplates'),
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            ('django.contrib.messages.context_processors.'
                             'messages'),
                        ],
                    },
                },
            ],
            'SECURE_PROXY_SSL_HEADER': ('HTTP_X_FORWARDED_PROTO', 'http')
        }


        os.environ["HTTPS"] = "on"
        member.attachSettings(settingsContent)
        member.attachSettings(settingsContentForHTTP)
        
        templatesSettings = {
            'TEMPLATES' : [
                {
                    'BACKEND': ('django.template.backends.'
                                'django.DjangoTemplates'),
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            ('django.contrib.messages.context_processors.'
                            'messages'),
                            "account.context_processors.account",
                            "django.core.context_processors.request", 
                            "pinax_theme_bootstrap.context_processors.theme",
                            "social_django.context_processors.backends",
                            "social_django.context_processors.login_redirect",  
                        ],
                    },
                },
            ],
        }
        
        loginUrlSettings = {
            'LOGIN_URL': '/accounts/login/',
            'LOGIN_REDIRECT_URL': '/settings',

            'SOCIAL_AUTH_LOGIN_URL': '/accounts/login/',
            'SOCIAL_AUTH_LOGIN_REDIRECT_URL': '/settings',

            'ACCOUNT_LOGIN_URL': '/accounts/login/',
            'ACCOUNT_LOGIN_REDIRECT_URL': '/settings',
        }

        httpSettings = {
            'SECURE_PROXY_SSL_HEADER': ('HTTP_X_FORWARDED_PROTO', 'http'),
            'DEFAULT_HTTP_PROTOCOL': 'http'
        }

        httpsSettings = {
            'SECURE_PROXY_SSL_HEADER': ('HTTP_X_FORWARDED_PROTO', 'https'),
            'DEFAULT_HTTP_PROTOCOL': 'https'
        }
        
        self.assertEqual(settingsContent['TEMPLATES'],
                         templatesSettings['TEMPLATES'])
        
        self.assertEqual(settingsContent['LOGIN_URL'], 
                         loginUrlSettings['LOGIN_URL'])

        self.assertEqual(settingsContent['LOGIN_REDIRECT_URL'], 
                         loginUrlSettings['LOGIN_REDIRECT_URL'])

        self.assertEqual(settingsContent['LOGIN_REDIRECT_URL'], 
                         loginUrlSettings['SOCIAL_AUTH_LOGIN_REDIRECT_URL'])
        
        self.assertEqual(settingsContent['ACCOUNT_LOGIN_REDIRECT_URL'], 
                         loginUrlSettings['SOCIAL_AUTH_LOGIN_REDIRECT_URL'])

        self.assertEqual(settingsContent['DEFAULT_HTTP_PROTOCOL'],
                         httpsSettings['DEFAULT_HTTP_PROTOCOL'])

        self.assertEqual(settingsContentForHTTP['DEFAULT_HTTP_PROTOCOL'],
                         httpSettings['DEFAULT_HTTP_PROTOCOL'])
