#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 13439 2022-05-03 18:17:06Z Jason $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Jason $ (last)
# $Date: 2022-05-04 02:17:06 +0800 (Wed, 04 May 2022) $
# $Revision: 13439 $

import os
import re
import warnings
from Iuno.Version import IUNO_VERSION

try:
    from Iuppiter.DistUtil import setup
except ImportError:
    iuppiter = 'Iuppiter'
    with open('REQUIREMENTS.txt') as f:
        lines = f.readlines()
    for line in lines:
        if re.match(f'{iuppiter}[>=<]=?', line):
            iuppiter = line
            break
            
    os.system(f'pip install {iuppiter} --no-cache-dir')
    from Iuppiter.DistUtil import setup

extraRequirements = [
    'pip install mysqlclient==1.4.2.post1',
    'pip install raven==6.10.0',
    'pip install celery==4.4.6',
    'pip install redis==3.5.3'
]


from sys import platform as _platform

# Python for Window Extensions (pypiwin32) is only for Windows.
if _platform == "win32":
    # win32 (https://pypi.python.org/pypi/pypiwin32/219)
    extraRequirements.append('pip install pypiwin32')   

# 要改版本號，請去改 Iuno.Version
# import six

# kwargs = {} if six.PY2 else {'encoding': 'utf8',}
# with open(os.path.join('Iuno', 'Version.py'), **kwargs) as f:
#     content = f.read()
#     exec(content)

# windows = ['pypiwin32']

setup(
    'Iuno',
    description="Support package for all Nuwa Information's server projects.",
    version=IUNO_VERSION,
    license='Proprietary License',
    author='Bear',
    author_email='bear@nuwainfo.com',
    url='http://www.nuwainfo.com/',
	extraRequirements=extraRequirements,
    extrasRequire={
        'scrapy': "REQUIREMENTS_SCRAPY.txt",
    }
)

# pip install Iuno[windows]
