#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Nuwa.py 9439 2015-09-25 08:01:30Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-09-25 16:01:30 +0800 (Fri, 25 Sep 2015) $
# $Revision: 9439 $

from Iuno.cloud.backend import BaseBackend

class Backend(BaseBackend):

    WINDOWS_MACHINES = (
        'naga.servehttp.com',
    )

    def _checkMonit(self, host, services):
        if host in Backend.WINDOWS_MACHINES:
            return True # Windows don't have monit to check.
        else:
            return super(Backend, self)._checkMonit(host, services)
