#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 10200 2017-08-20 02:49:07Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-20 10:49:07 +0800 (週日, 20 八月 2017) $
# $Revision: 10200 $

import os
import logging

from django.conf import settings

ROOT_DIR_PATH = os.path.abspath(
    os.path.join('.'))

if hasattr(settings, 'TEMPLATES'):
    TEMPLATES_DIR_PATH = settings.TEMPLATES[0]['DIRS'][0]
else:
    TEMPLATES_DIR_PATH = os.path.abspath(
        os.path.join('.', 'templates'))
    
if settings.DEBUG:
    if hasattr(settings, 'STATICFILES_DIRS'):
        STATIC_DIR_PATH = settings.STATICFILES_DIRS[0]
    else:
        STATIC_DIR_PATH = os.path.abspath(
            os.path.join('.', 'static'))
else:
    if hasattr(settings, 'STATIC_ROOT'):
        STATIC_DIR_PATH = settings.STATIC_ROOT
    else:
        STATIC_DIR_PATH = os.path.abspath(
            os.path.join('.', 'static'))
            
FIXTURES_DIR_PATH = os.path.abspath(
    os.path.join('.', 'fixtures'))
    
IMAGES_DIR_PATH = os.path.abspath(
    os.path.join('.', 'images'))

def cerateLogger(name, fileHandlername):
    logger = logging.getLogger(name)
    logger.setLevel(logging.DEBUG)
    handler = logging.StreamHandler()
    handler.setFormatter(
        logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
    logger.addHandler(handler)
    fileHander = logging.FileHandler(fileHandlername)
    fileHander.setLevel(logging.WARNING)
    logger.addHandler(fileHander)
    return logger