#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: assign_templates.py 10200 2017-08-20 02:49:07Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-20 10:49:07 +0800 (週日, 20 八月 2017) $
# $Revision: 10200 $

import os
import shutil
import random
import math

from django.core.management.base import BaseCommand, CommandError

from Zephyrus.boilerplate.management.commands import cerateLogger

logger = cerateLogger(__name__, "AssignTemplates.log")

DIR_TEMPLATES_NUMBER = 100
CHOSE_NUMBER = 20

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    args = '<start folder> <destination folder>'

    def handle(self, *args, **options):
        if len(args) < 2:
            raise CommandError(
                "You must specify a folder to get template."
                )

        startPath = args[0]
        dstPath = args[1]

        for root, dirs, files in os.walk(startPath):
            if not root == startPath:
                break

            random.shuffle(dirs)
            
            for i, dir in enumerate(dirs, 0):
                dirPath =  os.path.join(startPath, dir)
                dirName = str(math.ceil(float(i + 1) / DIR_TEMPLATES_NUMBER))
                dst = os.path.join(dstPath, dirName, dir)
                shutil.copytree(dirPath, dst)

                if (i + 1) % DIR_TEMPLATES_NUMBER == 0:
                    with open(
                        os.path.join(dstPath, dirName, "%s.txt" % dirName),
                         'w') as txt:
                        start = int(i - DIR_TEMPLATES_NUMBER + 1)
                        end = int(i + 1)
                        randomDir = dirs[start:end]
                        
                        txt.write('-----Sample Template-----\n')
                        txt.write('\n'.join(random.sample(randomDir, CHOSE_NUMBER)))
                        txt.write('\n-----All Template-----\n')
                        txt.writelines('\n'.join(randomDir))
            
