#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: create_zip.py 10200 2017-08-20 02:49:07Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-20 10:49:07 +0800 (週日, 20 八月 2017) $
# $Revision: 10200 $

import os
import shutil
import zipfile
import json
import hashlib

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, STATIC_DIR_PATH, 
    IMAGES_DIR_PATH, ROOT_DIR_PATH, FIXTURES_DIR_PATH)
from Zephyrus.boilerplate.management.commands import cerateLogger

logger = cerateLogger(__name__, "CreateZip.log")

class Command(BaseCommand):

    help = 'Create zip file to destination folder.'
    args = '<destination folder>'

    def handle(self, *args, **options):
        if len(args) < 1:
            raise CommandError(
                "You must specify a folder to get template."
                )

        

        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)

        content = ''
        for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
            for temp in files:
                with open(os.path.join(root, temp)) as f:
                    content += f.read()
        data['checksum'] = hashlib.md5(content).hexdigest()

        with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
            line = json.dumps(data)
            f.write(line)

        zip = zipfile.ZipFile(
            os.path.join(ROOT_DIR_PATH, 'template.zip'), mode='w')

        logger.info("-----Start copy templates-----")
        for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
            for file in files:
                path = os.path.join(root, file)
                dst = "./templates/%s" % file
                logger.info("Zip " + path)
                zip.write(path, dst)
        
        
        index = len(STATIC_DIR_PATH) + 1
        for root, dirs, files in os.walk(STATIC_DIR_PATH):
            for file in files:
                path = os.path.join(root, file)
                
                dst = "./static/%s" % path[index:]
                logger.info("Zip " + path)
                zip.write(path, dst)
        for root, dirs, files in os.walk(FIXTURES_DIR_PATH):
            for file in files:
                path = 'fixtures/%s' % file
                logger.info("Zip " + path)
                zip.write(path)
                
        temp = get_template('boilerplate/py/setup.py')
        content = temp.render()
        with open(os.path.join(ROOT_DIR_PATH, 'setup.py'), 'wb') as f:
            f.write(content.encode('utf8'))
            
        temp = get_template('boilerplate/txt/README.txt')
        content = temp.render()
        with open(os.path.join(ROOT_DIR_PATH, 'README.txt'), 'w') as f:
            f.write(content.encode('utf8'))

        zip.write('./README.txt')
        logger.info("Zip README.txt")
        
        zip.write('./setup.py')
        logger.info("Zip setup.py")

        zip.close()

        dst = args[0]

        zip = zipfile.ZipFile(
            os.path.join(dst, '%s.zip' % data['upc']), mode='w')
        zip.write('info.json')
        
        for root, dirs, files in os.walk(IMAGES_DIR_PATH):
            for file in files:
                path = 'images/%s' % file
                logger.info("Zip " + path)
                zip.write(path)
                
        zip.write('template.zip')
        zip.close()
        
        if os.path.exists(FIXTURES_DIR_PATH):
            shutil.rmtree(FIXTURES_DIR_PATH)
        if os.path.exists(IMAGES_DIR_PATH):
            shutil.rmtree(IMAGES_DIR_PATH)
        if os.path.isfile('./README.txt'):
            os.remove('./README.txt')
        if os.path.isfile('./setup.py'):
            os.remove('./setup.py')
        if os.path.isfile('./info.json'):
            os.remove('./info.json')
        if os.path.isfile('./template.zip'):
            os.remove('./template.zip')
        
        logger.info('-----All OK!-----')