#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: filter_templates.py 10200 2017-08-20 02:49:07Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-20 10:49:07 +0800 (週日, 20 八月 2017) $
# $Revision: 10200 $

import os
import shutil

from django.core.management.base import BaseCommand, CommandError
from Zephyrus.boilerplate.management.commands import cerateLogger

logger = cerateLogger(__name__, "FilerTemplate.log")

class Command(BaseCommand):

    help = 'Filter templates and to destination folder.'
    args = '<start folder> <destination folder>'

    def handle(self, *args, **options):
        if len(args) < 2:
            raise CommandError(
                "You must specify a folder to get template."
                )

        startPath = args[0]
        dstPath = args[1]
        
        for f in os.listdir(startPath):
            tempPath = os.path.join(startPath, f)
            
            num = 0
            for root, dirs, files in os.walk(tempPath):
                for f2 in files:
                    path = os.path.join(root, f2)
                    result = os.path.splitext(path)[-1]
                    if result == ".html":
                        num += 1
            if num == 1:
                dst = os.path.join(dstPath, f)
                try:
                    shutil.copytree(tempPath, dst)
                    logger.info('Copy %s' % f)
                except Exception as e:
                    with open('./Error.txt', 'a+') as err:
                        err.write(str(e) + "\n")
                        
        logger.info('ALL OK!')