#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: get_template.py 10200 2017-08-20 02:49:07Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-20 10:49:07 +0800 (週日, 20 八月 2017) $
# $Revision: 10200 $

import os
import shutil

from django.core.management.base import BaseCommand, CommandError

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, STATIC_DIR_PATH, IMAGES_DIR_PATH, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import cerateLogger

logger = cerateLogger(__name__, "GetTemplate.log")

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    args = '<destination folder>'

    def handle(self, *args, **options):
        if len(args) < 1:
            raise CommandError(
                "You must specify a folder to get template."
                )

        path = args[0]

        try:
            shutil.rmtree(TEMPLATES_DIR_PATH)
            logger.info("Remove Temeplates folder.")
        except Exception as e:
            logger.info("Temeplates folder is not exist.")
            os.mkdir(TEMPLATES_DIR_PATH)
        else:
            os.mkdir(TEMPLATES_DIR_PATH)
            logger.info("Create Temeplates folder.")

        try:
            shutil.rmtree(STATIC_DIR_PATH)
            logger.info("Remove static folder.")
        except Exception as e:
            logger.info("Static folder is not exist.")
            os.mkdir(STATIC_DIR_PATH)
        else:
            os.mkdir(STATIC_DIR_PATH)
            logger.info("Create static folder.")
            
        try:
            shutil.rmtree(IMAGES_DIR_PATH)
            logger.info("Remove images folder.")
        except Exception as e:
            logger.info("Images folder is not exist.")
            

        logger.info("-----Start copy templates-----")
        
        imgPath = os.path.join(path, 'images')
        shutil.copytree(imgPath, IMAGES_DIR_PATH)
        logger.info("Copy images folder to root.")

        copyHtml = False
        for root, dirs, files in os.walk(path):
            if 'info.json' in files:
                jsonPath = os.path.join(root, 'info.json')           
                jsonDst = os.path.join(ROOT_DIR_PATH, 'info.json')
                shutil.copyfile(jsonPath, jsonDst)
                logger.info('Copy %s to root.' % 'info.json')

            if "index.html" in files or "Index.html" in files:
                copyHtml = True
            else:
                for f in files:
                    if f.endswith('.html'):
                        copyHtml = True
                        logger.warn(
                            ("'%s' not have 'index.html', but have %s") % 
                            (path, f))
            

            if copyHtml:
                for fileName in files:
                    filePath = os.path.join(root, fileName)
                    if fileName.endswith('.html'):
                        dst = os.path.join(TEMPLATES_DIR_PATH, fileName)
                        shutil.copyfile(filePath, dst)
                        logger.info(
                            'Copy %s to templates folder.' % fileName)
                    else:
                        dst = os.path.join(STATIC_DIR_PATH, fileName)
                        shutil.copyfile(filePath, dst)
                        logger.info('Copy %s to static folder.' % fileName)
                for dirName in dirs:
                    dirPath = os.path.join(root, dirName)
                    dst = os.path.join(STATIC_DIR_PATH, dirName)
                    shutil.copytree(dirPath, dst)
                    logger.info('Copy %s to static folder.' % dirName)
                break
        if not copyHtml:
            logger.error("'%s' not have html file" % path)

        logger.info('-----All OK!-----')