#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 10982 2018-04-16 08:14:06Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-04-16 16:14:06 +0800 (週一, 16 四月 2018) $
# $Revision: 10982 $

import os

from django.conf import settings

# FIXME: 看 Iuno 該怎麼設定
STATIC_DIR = None

if hasattr(settings, "STATIC_ROOT"):
    STATIC_DIR = settings.STATIC_ROOT

if not STATIC_DIR:
    STATIC_DIR = os.path.join(settings.BASE_DIR, "static")

TEMPLATE_DIR = settings.TEMPLATES[0]['DIRS'][0]

BACKUP_DIR_NAME = "_Iuno.template_editor_backup" 

BACKUP_FILE_DIR = os.path.join(
    STATIC_DIR, BACKUP_DIR_NAME)

if not os.path.isdir(BACKUP_FILE_DIR):
    os.mkdir(BACKUP_FILE_DIR)
