#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9948 2017-05-07 06:08:11Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-07 14:08:11 +0800 (�g��, 07 ���� 2017) $
# $Revision: 9948 $

from django.db import models
from django.utils.translation import ugettext_lazy as _
from django.core.validators import MaxValueValidator

from cms.models import CMSPlugin

from Zephyrus.facebook import settings

class FacebookFan(CMSPlugin):
    url = models.URLField()
    limit = models.PositiveIntegerField(default=100, 
        validators=[MaxValueValidator(100),])

    renderTemplate = models.CharField(
        _('Fan Template'), max_length=150, blank=True,
        choices=settings.ZEPHYRUS_FACEBOOK_FAN_TEMPLATES,
        default=settings.ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE,
    )

    # display:
    ordinaryDisplay = models.BooleanField(
        _('Display ordinary article'), default=True)
    videoDisplay = models.BooleanField(
        _('Display video article'), default=False)
    albumDisplay = models.BooleanField(
        _('Display album photo article'), default=False)
    shareDisplay = models.BooleanField(
        _('Display share article'), default=False)
    commerceDisplay = models.BooleanField(
        _('Display commerce article'), default=True)
    
class FacebookPhoto(CMSPlugin):
    url = models.URLField()
    limit = models.PositiveIntegerField(default=100,
        validators=[MaxValueValidator(100),])
    renderTemplate = models.CharField(
        _('Photo Template'), max_length=150, blank=True,
        choices=settings.ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES,
        default=settings.ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE,
    )
