#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9659 2016-05-04 09:55:22Z Judy $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-05-04 17:55:22 +0800 (Wed, 04 May 2016) $
# $Revision: 9659 $
"""
Celery tasks which should be run at cloud worker.
"""

import inspect
import logging

from Iuno.cloud.queue.App import app

from Iuno.browser import tasks

logger = logging.getLogger(__name__)

# Register all tasks.
for name, value in inspect.getmembers(tasks):
    if inspect.isfunction(value) and value.__module__ == tasks.__name__:
        locals()[name] = app.task(queue='browser')(value)
