#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 12803 2021-03-18 07:29:01Z Lavender $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-03-18 15:29:01 +0800 (週四, 18 三月 2021) $
# $Revision: 12803 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

from Iuppiter.Model import BaseModelMixin

from emencia.django.newsletter.models import Newsletter, Contact

class CloudMailInformation(models.Model, BaseModelMixin):
    """
    Mail sending information.
    """
    newsletter = models.ForeignKey(Newsletter, unique=False, on_delete=models.CASCADE)

    contact = models.ForeignKey(Contact, unique=False, on_delete=models.CASCADE)

    # Response id for sent mail.
    messageId = models.TextField(max_length=2048)
    # Response message for sent mail.
    message = models.TextField(default='')

class NewsletterInformation(models.Model, BaseModelMixin):

    newsletter = models.ForeignKey(Newsletter, on_delete=models.CASCADE)

    sync = models.BooleanField(default=True)

class ErrorMessage(models.Model):

    message =  models.CharField(max_length=2048, blank=True, null=True)

    newsletter = models.ForeignKey(Newsletter, verbose_name=_('newsletter'), on_delete=models.CASCADE)

    contact = models.ForeignKey(Contact, verbose_name=_('contact'), on_delete=models.CASCADE)
