#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 13445 2022-05-09 07:35:44Z Jason $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Jason $ (last)
# $Date: 2022-05-09 15:35:44 +0800 (週一, 09 五月 2022) $
# $Revision: 13445 $

import os
import re
from Iuno.Version import IUNO_VERSION

try:
    from Iuppiter.DistUtil import setup
except ImportError:
    iuppiter = 'Iuppiter'
    with open('REQUIREMENTS.txt') as f:
        lines = f.readlines()
    for line in lines:
        if re.match(f'^{iuppiter}[>=<]=?', line):
            iuppiter = line
            break
            
    os.system(f'pip install {iuppiter} --no-cache-dir')
    from Iuppiter.DistUtil import setup 

setup(
    'Iuno',
    description="Support package for all Nuwa Information's server projects.",
    version=IUNO_VERSION,
    license='Proprietary License',
    author='Bear',
    author_email='bear@nuwainfo.com',
    url='http://www.nuwainfo.com/',
    extrasRequire={
        'scrapy': "REQUIREMENTS_SCRAPY.txt",
        'windows': "REQUIREMENTS_WINDOWS.txt",
    }
)
