#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 10364 2017-10-10 17:26:52Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-10-11 01:26:52 +0800 (Wed, 11 Oct 2017) $
# $Revision: 10364 $

from django.conf.urls import url, include, patterns

import views

urlpatterns = patterns('',
    # Editor.
    url(r'^', include('emencia.django.newsletter.urls')),
    url(r'^plus/editor/', include('Theophrastus.editor.urls')),

    # Cloud.
    url(r'^plus/cloud/', include('Theophrastus.cloud.urls')),

    # Newsletter.
    url(r'^newsletter/', include('Theophrastus.newsletter_extension.urls')),

    # Statistics.
    url(r'^statistics/',
        include('Theophrastus.statistics.urls.statistics')),

    # Subscribers.
    url(r'^subscribers/',
        include('Theophrastus.statistics.urls.subscribers')),

    # Other functionally.
    url(r'^slug/get/$', views.getSlugName,
        name="Theophrastus.views.getSlugName"),
    url(r'^mailingList/get/$', views.getMailingListInfo,
        name="Theophrastus.views.getMailingListInfo"),
    url(r'^facebook/feed/complete/$', views.feedComplete,
        name="Theophrastus.facebook.feed.complete"),

    # Integration.
    url(r'^integration/', include('Theophrastus.integration.urls')),

    # API.
    url(r'^api/', include('Theophrastus.api.urls')),

    # django-selectable.
    url(r'^newsletters/selectable/', include('selectable.urls')),
)
