#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 9706 2016-08-31 08:58:22Z Eric $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2016-08-31 16:58:22 +0800 (Wed, 31 Aug 2016) $
# $Revision: 9706 $

import os

try:
    from Iuppiter.DistUtil import setup
except ImportError:
    os.system('pip install Iuppiter --no-cache-dir')
    from Iuppiter.DistUtil import setup
    
extraRequirements = []

from sys import platform as _platform

# Python for Window Extensions (pypiwin32) is only for Windows.
if _platform == "win32":
    # win32 (https://pypi.python.org/pypi/pypiwin32/219)
    extraRequirements.append('pip install pypiwin32')    

setup(
    'Iuno',
    description="Support package for all Nuwa Information's server projects.",
    version='%s.%s' % ('2.1.9', "$Revision: 9706 $"[11:-2]),
    license='Proprietary License',
    author='Bear',
    author_email='bear@nuwainfo.com',
    url='http://www.nuwainfo.com/',
)
